# Introduction 

Kpow offers a number of REST API modules so that you can integrate Kpow into your product or [GitOps](https://about.gitlab.com/topics/gitops/) pipeline.

## What data is available?

Kpow's REST API is broken down into individual modules. Below is the current status of each API module:

* [x] **Kafka Admin API**
  - [x] Topics
  - [x] Groups
  - [x] Producers
  - [x] Transactions
  - [x] Brokers
  - [x] KRaft
  - [x] Quotas
  - [ ] ACLs
* [x] **Kafka Connect API**
  - [x] Apache Kafka Connect
    - [x] Connectors
    - [x] Connector Plugins
  - [ ] AWS MSK Connect
    - [ ] Connectors
* [x] **Schema Registry API**
  - [x] Confluent Schema Registry
    - [x] Schemas
    - [x] Subjects
    - [ ] Contexts
  - [x] AWS Glue Schema Registry
    - [x] Schemas
    - [x] Subjects
* [ ] **ksqlDB API**
* [ ] **Kafka Streams API**
* [ ] **Kpow Data API**
  - [ ] Data inspect
  - [ ] Data produce
  - [ ] kREPL
* [x] **Kpow User API**
  - [x] User details
  - [x] View user mutations
  - [x] Manage scheduled mutations
* [ ] **Kpow Admin API**
  - [ ] Bulk actions
  - [ ] Temporary policies
  - [ ] Staged mutations
* [x] **Metrics API**

## What's the future of the API?

Check out the [Factor House roadmap](https://factorhouse.io/roadmap/) to find out what's in development and being considered for addition next.

# Configuration

By default, Kpow's API is disabled. You can enable Kpow's API by setting:

```bash 
API_ENABLED="true"
```

The API will now be served on port 3001. You can specify a custom port by setting:

```bash 
API_PORT=4000
```

All standard Kpow server configuration such as keystores, SSL and SNI host checks can also be configured. Simply refer to the [web server environment variables reference](https://docs.factorhouse.io/kpow/configuration/config-kpow/environment-variables).

**Note:** all API web server configuration is prefixed with `API_`.

# Authentication

You can optionally secure Kpow's REST API using API keys. 

When secured, Kpow's REST APIs implement Kpow's standard [role-based access control](https://docs.factorhouse.io/kpow/authorization/role-based-access-control) and [multi-tenancy](https://docs.factorhouse.io/kpow/authorization/tenants) features. Once authentication has been enabled you must be both authenticated and authorized to access Kpow's API.

## API keys

Kpow uses [JAAS](https://docs.oracle.com/javase/8/docs/technotes/guides/security/jaas/JAASRefGuide.html) to define API users and their associated roles.

You can enable authentication by setting:

```bash 
API_AUTH_PROVIDER_TYPE="jetty"
```

### Specifying a JAAS file

Kpow will authenticate all users defined in the `kpow_api` JAAS security realm.

You will need to provide a JAAS login config file to Kpow. You can pass a JVM option when starting Kpow like:

```bash 
-Djava.security.auth.login.config=/config/jaas/hash-jaas.conf
```

Where the contents of `/config/jaas/hash-jaas.conf` looks like:

```bash 
kpow_api {
         org.eclipse.jetty.jaas.spi.PropertyFileLoginModule required
         debug="true"
         file="/config/jaas/realm.properties";
};
```

More information about supported JAAS login modules supported can be found at the [official Jetty documentation site](https://eclipse.dev/jetty/documentation/jetty-9/index.html#jaas-support). 

#### Docker configuration

If you are running Kpow from Docker, you can set the `JVM_OPTS` environment variable:

```bash
JVM_OPTS="-server -Dclojure.core.async.pool-size=8 -XX:MaxInlineLevel=15 -Djava.awt.headless=true -XX:InitialRAMPercentage=70 -XX:MaxRAMPercentage=70 -Djava.security.auth.login.config=/config/jaas/hash-jaas.conf"
```

The above code snippet appends the `-Djava.security.auth.login.config` property to the default Kpow JVM opts.

You can then add a [volume mount](https://docs.docker.com/storage/volumes/) that mounts your `hash-jaas.conf` and `realm.properties` files.

### Creating API users

API users are defined in the `/config/jaas/realm.properties` file mentioned in the previous section. 

When using the `org.eclipse.jetty.jaas.spi.PropertyFileLoginModule`, all API users are stored in the following format: `<user>: <api-key>[,<rolename> ...]`.

Kpow has a built-in command line utility to generate API keys from your terminal:

```plain
$ docker run factorhouse/kpow java -cp /opt/factorhouse/lib/kpow.jar factorhouse.server.api.password tx-corp-machine-user

Username:tx-corp-machine-user
API Key:9e5f1f9a15163b9e1c035974457b97e6a608aa4af9aff3a41ca7e5b0caea8207
OBF:1bb51ino19j61kfh1hzj1ta81jkn1rwd18cg1iz619bv1jrk1a4b1rpc1jyt1iur194s1rwh18qk1jd81jri1jkn1bb11jkd1iky19xc1j6d1rpc1bi819ja1ju61iz81j1m1jrk19iw1bi61rpa1j8p19xa1ing1jn51bb51jmv1ju81jg218qq1rwd194y1irv1k151rpa1a4j1ju619c31j1o18ce1rwh1jmv1ta61i271kcx19j01ikq1bb1
MD5:817685Ab20FbBaF904Ca65596e44A1Ac
CRYPT:txWflfi0LTpak
```

The above command has generated an API key for the user `tx-corp-machine-user`.

You can append to your `/config/jaas/realm.properties` the following line: 

```
tx-corp-machine-user MD5:817685Ab20FbBaF904Ca65596e44A1Ac,API_USER_ROLES
```

Where `API_USER_ROLES` are the roles you wish to assign to this API user.

**Notes:** 

* You will need to keep your plaintext API key handy for later use. This is what you use to authenticate with Kpow when making HTTP requests.
* The passwords in the realm properties file are obfuscated using **weak** hashing methods like `MD5`. **It is always reccomended that you properly secure your realm.properties file at rest.**
  * Support for storing passwords with cryptographic hash functions like `BCRYPT` is coming soon. If this is a hard requirement please contact [support@factorhouse.io](mailto:support@factorhouse.io).

### Using your API key

To use an API key, you must set the `Authorization` header with [basic authentication credentials](https://en.wikipedia.org/wiki/Basic_access_authentication).

To generate a basic authentication header, you can run the following command from your terminal:

```bash 
$ echo "Authorization: Basic $(echo -n 'tx-corp-machine-user:9e5f1f9a15163b9e1c035974457b97e6a608aa4af9aff3a41ca7e5b0caea8207' | base64)"
```

You can now authenticate and use Kpow's REST API:

```bash 
AUTH_HEADER="Authorization: Basic dHgtY29ycC1tYWNoaW5lLXVzZXI6OWU1ZjFmOWExNTE2M2I5ZTFjMDM1OTc0NDU3Yjk3ZTZhNjA4YWE0YWY5YWZmM2E0MWNhN2U1YjBjYWVhODIwNw=="
curl -XGET -H "$AUTH_HEADER" https://kpow.mycorp.org:3001/kafka/v1/clusters
```

## OAuth (OIDC)

**Coming soon**

Support for authenticating Kpow's API with [Kpow's OAuth integration](https://docs.factorhouse.io/kpow/authentication/openid) + [OpenID Connect (OIDC)](https://openid.net/developers/how-connect-works/) is currently in development.

Please contact [sales@factorhouse.io](mailto:sales@factorhouse.io) if this is a requirement for your organisation. 


## Mutual TLS

**Coming soon**

Mutual TLS adds another layer of authentication to Kpow's API by requiring both the client and the server to present certificates, ensuring that both parties are who they claim to be.

Support for mutual TLS authentication with Kpow's REST API is currently in development.

Please contact [sales@factorhouse.io](mailto:sales@factorhouse.io) if this is a requirement for your organisation.

# Authorization


## Assinging RBAC policies

Now that you have created your first API key, you can start assigning [RBAC policies](https://docs.factorhouse.io/kpow/authorization/role-based-access-control).

For example, you can assign the `TOPIC_CREATE` action to the `ops-admin` role within your RBAC YAML file:

```yaml
policies:
  - resource: ["*"]
    effect: "Allow"
    actions: ["TOPIC_CREATE"]
    role: "ops-admin"
```

## Configuring tenancy

Multi-tenancy allows you to configure Kpow to restrict visibility of Kafka resources. All of Kpow's REST API endpoints work with Kpow's multi-tenancy capabilities.

See the article [How to manage Kafka visibility with Multi-tenancy](https://factorhouse.io/blog/how-to/manage-kafka-visibility-with-multi-tenancy/) for an overview on this feature and how to assign tenants to roles.

By default, the global tenant will be used when making API requests. You can specify a custom tenant with the `X-Tenant-Id` header:

``` 
curl -XGET -H "$AUTH_HEADER" -H "X-Tenant-Id:MYCustomTenant" https://kpow.mycorp.org:3001/kafka/v1/clusters/xxx/topics
```

# API structure

## Versioning

### Major API Changes

Each of Kpow's API models are individually versioned via the path. For instance: `GET /kafka/v1/....`

When significant API modifications occur, such as breaking changes to the data model, a new API version endpoint will be introduced to the OpenAPI specification.

Clients are expected to manually migrate to the latest API version at their convenience. Despite the introduction of newer API versions, older endpoints will continue to be supported.

All details regarding API breaking changes will be documented in the [changelog](https://factorhouse.io/kpow/changelog/).

### Minor API Changes

Within a versioned API module (e.g., `/kafka/v1/...`), there will be no major breaking changes.

Minor API adjustments, such as the addition of new fields, can be accessed by specifying the content type of the request.

For instance:

* `application/vnd.kafka.v1.1+json` - specifies version v1.1 of the data model.
* `application/json` - without a vendor-specific content type denotes the most recent data model within the major version.

The content types each endpoint accepts are documented in detail below.

Changes introduced in minor versions are accretive and non-breaking, such as the addition of new fields without disrupting the API contract.

## Metadata object

Each response contains a `metadata` object. This includes information such as:

* The tenant id that was used in the request
* The resource ids (for example Kafka cluster or Schema registry) used in the request
* The response id from the server. This can be used to view the result of the API request in the audit log.

# License

See the [Kpow EULA](https://factorhouse.io/kpow/eula/).

Copyright © Factor House 2024. Apache, Apache Kafka, Kafka, Apache Flink, Flink, and associated open source project names are trademarks of the Apache Software Foundation.