(defproject io.factorhouse/core "1.0.0"

  :description "Factor House monorepo"

  :dependencies [[org.clojure/clojure "1.12.1"]
                 [org.clojure/tools.logging "1.3.0"]
                 [org.clojure/core.async "1.7.701"]
                 [org.clojure/test.check "1.1.1"]
                 [org.clojure/tools.cli "1.1.230"]
                 [com.cognitect/transit-clj "1.0.333"]
                 [org.clojure/tools.reader "1.5.0"]

                 [io.factorhouse/re-frame-bridge "0.1.17"]
                 [io.factorhouse/hsx "0.1.23"]

                 [org.slf4j/slf4j-api "2.0.17"]
                 [org.slf4j/log4j-over-slf4j "2.0.17"]      ;; aws v1 lib aws-java-sdk-sts is a transitive dep of glue serdes, it brings in sdk-core which contains com.amazonaws.AmazonWebServiceClient which still uses log4j, warns on startup without this dep

                 [ch.qos.logback/logback-classic "1.3.15"]  ;; Logback 1.3: Java8+, JavaEE. Logback 1.4: Java11+, JakartaEE (https://logback.qos.ch/dependencies.html), 1.5 is a drop in replacement for 1.4.
                 [ch.qos.logback.contrib/logback-json-classic "0.1.5"]
                 [ch.qos.logback.contrib/logback-jackson "0.1.5"]
                 [org.codehaus.janino/janino "3.1.12"]      ;; required for logback conditional processing

                 [ring-oauth2 "0.2.0"]
                 [ring/ring-defaults "0.3.4" :exclusions [javax.servlet/javax.servlet-api]] ;; slipway brings in Jetty's implementation of the servlet-api
                 [com.taoensso/sente "1.17.0"]
                 [ring-cors "0.1.13"]
                 [metosin/reitit "0.7.2" :exclusions [ring/ring-core
                                                      org.clojure/spec.alpha
                                                      metosin/reitit-swagger metosin/reitit-swagger-ui metosin/ring-swagger-ui]] ;; CVE-2024-45801 in 0.7.2 related to dompurify (npm) used by swagger-ui, also we don't use it
                 [metosin/malli "0.17.0"]
                 [instaparse "1.5.0"]
                 [ring-basic-authentication "1.2.0"]
                 [io.prometheus/simpleclient "0.16.0"]
                 [io.prometheus/simpleclient_common "0.16.0"]
                 [joda-time "2.10.14"]                      ;; explicit dep because of cflt-serdes 7.8.0 (2.10.14 + conflicts) aws glue (2.10.2) and clj-time (2.10). We use latest 2.10.x.
                 [clj-time "0.15.2"]
                 [hiccup "1.0.5"]

                 ;; explicit requirement of transitive dependency, confluent/aws bring in 2.16.x, cheshire 2.17.x, reitit 2.17.x other libs 2.13.x or 2.15.x. We choose latest 2.18.x branch
                 [com.fasterxml.jackson.core/jackson-core "2.18.2"]
                 [com.fasterxml.jackson.core/jackson-annotations "2.18.2"]
                 [com.fasterxml.jackson.core/jackson-databind "2.18.2"]
                 ;; These two are only referenced in cheshire
                 [com.fasterxml.jackson.dataformat/jackson-dataformat-cbor "2.18.2"]
                 [com.fasterxml.jackson.dataformat/jackson-dataformat-smile "2.18.2"]
                 ;; This references in reitit and json serdes
                 [com.fasterxml.jackson.datatype/jackson-datatype-jsr310 "2.18.2"]

                 [integrant "0.8.1"]                        ;; required for cronut, once integrant split from that project can replace with [weavejester/dependency "0.2.1"]

                 ;; we are going to have to deal with this abandoned metrics-clojure lib at some point, rm it entirely i think is the way (see kpow metrics v2)
                 [metrics-clojure "2.10.0"]
                 [metrics-clojure-jvm "2.10.0"]

                 [io.factorhouse/cronut "0.2.7"]
                 [io.factorhouse/kpow-secure "1.0.3"]
                 [com.troy-west/frequencies "0.1.1"]

                 [clj-http "3.13.0" :exclusions [commons-io commons-logging commons-codec]] ;; see note on commons-x at the bottom of this vector
                 [cheshire "5.13.0"]

                 [clj-commons/clj-yaml "1.0.29"]
                 [expound "0.9.0"]
                 [fipp "0.6.27" :exclusions [org.clojure/core.rrb-vector]] ;; reitit brings in a later version of rrb-vector
                 [selmer "1.12.62"]                         ;; selmer is used by klang for interpolating variables into queries from file

                 ;; Core AWS libs in msk-iam-auth and schema-registry-serde
                 ;; Technically these could be in the Kpow profile, but we have a custom StsProvider (Java) class in Factorhouse scope that uses them
                 [software.amazon.awssdk/sts "2.31.6"]
                 [software.amazon.awssdk/netty-nio-client "2.31.6"] ;; runtime dep of sts


                 ;; Common Explicit Depencies Required By All Projects
                 [commons-io "2.19.0"]                      ;; ring uses commons-io 2.19.0, reitit 2.13.0 (via ring-core) avro serdes 2.15.1/2.16.1, and clj-http 2.16.1. We favour the serdes libs. It's safe to bump up wrt ring as ring only users IOUtils for file upload / multipart content
                 [commons-codec "1.17.1"]                   ;; aws libs use commons-codec 1.17.1, clj-http 1.16.1, xmlsec 1.15.1 - changelog looks fine to advance to 1.17.1
                 [commons-logging "1.3.2"]                  ;; clj-http on 1.2, confluent json-schema serdes on 1.3.2, and commons-validator on 1.3.2 we favour confluent
                 [com.google.code.gson/gson "2.13.1"]       ;; required for Clojurescript compilation to work, Cljs requires gson, kafka-proto 7.9.0 brings in 2.8.9 only for Kpow, this provides for all products. Google MSK auth brings in 2.10.1.
                 [com.google.guava/guava "32.0.1-jre"]]     ;; bring in explicit guava dep at same level as confluent-avro serdes 7.9.0, this is the hw mark of serdes+coveo, avoids CVE in coveo version

  :clean-targets ^{:protect false} [:target-path ".shadow-cljs"]

  ;; Note: Kaocha picks up test srcs from tests.edn, it does not work dynamically with `with-profile x`
  :profiles {;; Java platform specific profiles
             :java-8-base                {:source-paths      ["modules/factorhouse/src-8"]
                                          :javac-options     ["-target" "8" "-source" "8"] ;; required to specifically set Java8 compatibilty
                                          :java-source-paths ["modules/factorhouse/src-java-8"]
                                          :dependencies      [;; Later versions of Ring require Java8+ (via org.apache.commons/commons-fileupload2-core transitive dep)
                                                              ;; Note: this version of ring suffers from CVE-2025-48976
                                                              [ring/ring-core "1.10.0"]
                                                              [io.factorhouse/slipway-jetty9 "1.1.20"]
                                                              [com.fasterxml.woodstox/woodstox-core "6.4.0"] ;; explicitly override 6.2.6 dep of saml-client for CVE-2022-40152 - I have checked release notes should be fine - dtw
                                                              [org.apache.santuario/xmlsec "2.2.6"] ;; Explicit due to CVE vuln in transitive dep via com.coveo/saml-client, we choose the latest of the 2.2.x branch contained in coveo 4.0.x
                                                              ;; Later versions of coveo/saml-client are not compatible with Java8 (they bump to latest OpenSAML which is 11+ only beyond this version)
                                                              [com.coveo/saml-client "4.0.3" :exclusions [org.apache.commons/commons-lang3]]]} ;; Jetty brings in 3.12, confluent avro serdes 3.14.0, in LDAP dep, coveo has both 3.12 and 3.11
             ;; Note: We could just build on JDK 17 and have :javac-options     ["--release" "11"] to maintain backwards compatibility to JDK11 JARs...
             ;;       In time inevitably some of our deps are going to use JDK17 / 21 features, so we may as well bifurcate on JDK targets moving forward and clearly deprecate versions as they age out.
             :java-17-base               {:javac-options     ["--release" "11"] ;; required when multiple JVM on the classpath for local dev, see: https://github.com/cursive-ide/cursive/issues/2428#issuecomment-2521902661
                                          :java-source-paths ["modules/factorhouse/src-java11"] ;; NOTE: this is called src-java11 not src-java-11 due to a dumb bug -> https://github.com/cursive-ide/cursive/issues/2624#issuecomment-1084104373
                                          :uberjar-name      "kpow-java11-standalone.jar"
                                          :source-paths      ["modules/factorhouse/src-11"]
                                          :dependencies      [[ring/ring-core "1.14.2"]
                                                              ;; LLM providers
                                                              [dev.langchain4j/langchain4j-anthropic "1.0.1-beta6" :exclusions [com.squareup.okio/okio-jvm org.jetbrains.kotlin/kotlin-stdlib com.fasterxml.jackson.core/jackson-annotations org.jetbrains.kotlin/kotlin-stdlib-jdk8 org.jetbrains.kotlin/kotlin-stdlib-jdk7 com.fasterxml.jackson.core/jackson-databind com.squareup.okio/okio com.fasterxml.jackson.core/jackson-core]]
                                                              [dev.langchain4j/langchain4j-open-ai "1.0.1" :exclusions [com.fasterxml.jackson.core/jackson-annotations com.fasterxml.jackson.core/jackson-databind com.fasterxml.jackson.core/jackson-core]]
                                                              [dev.langchain4j/langchain4j-ollama "1.0.1-beta6" :exclusions [com.fasterxml.jackson.core/jackson-annotations com.fasterxml.jackson.core/jackson-databind com.fasterxml.jackson.core/jackson-core]]
                                                              [dev.langchain4j/langchain4j "1.0.1" :exclusions [com.fasterxml.jackson.core/jackson-annotations com.fasterxml.jackson.core/jackson-databind com.fasterxml.jackson.core/jackson-core]]
                                                              [dev.langchain4j/langchain4j-bedrock "1.0.1-beta6" :exclusions [com.fasterxml.jackson.core/jackson-annotations com.fasterxml.jackson.core/jackson-databind com.fasterxml.jackson.core/jackson-core]]
                                                              [io.factorhouse/slipway-jetty10 "1.1.20"]
                                                              [org.apache.santuario/xmlsec "2.3.4"] ;; Explicit due to CVE vuln in transitive dep via com.coveo/saml-client, we choose the latest of the 2.3.x branch contained in coveo 4.1.x
                                                              [org.apache.velocity/velocity-engine-core "2.4" :exclusions [org.apache.commons/commons-lang3]] ;; Explicit bump to 2.4 to avoid phantom shaded 2.8.0 inclusion triggering CVE, see: https://github.com/aquasecurity/trivy/discussions/7673
                                                              [com.coveo/saml-client "4.1.2" :exclusions [javax.servlet/javax.servlet-api ;; Jetty 10.x brings in its own impl of the servlet-api (different lib, same java path), we prefer that.
                                                                                                          org.apache.httpcomponents/httpcore ;; Clj-http brings in http-core 4.4.14 vs 4.4.15 in this dep
                                                                                                          io.dropwizard.metrics/metrics-core ;; Metrics-clj brings in an ancient version of io.dropwizard, if saml stops working look at rm'ing metrics-core as a fix
                                                                                                          org.apache.commons/commons-lang3]]]}
             :java-11-base               {:source-paths      ["modules/factorhouse/src-11"]
                                          :javac-options     ["--release" "11"] ;; required when multiple JVM on the classpath for local dev, see: https://github.com/cursive-ide/cursive/issues/2428#issuecomment-2521902661
                                          :java-source-paths ["modules/factorhouse/src-java11"] ;; NOTE: this is called src-java11 not src-java-11 due to a dumb bug -> https://github.com/cursive-ide/cursive/issues/2624#issuecomment-1084104373
                                          :uberjar-name      "kpow-java11-standalone.jar"
                                          :dependencies      [[ring/ring-core "1.14.2"]
                                                              ;; LLM providers
                                                              [dev.langchain4j/langchain4j-anthropic "1.0.1-beta6" :exclusions [com.squareup.okio/okio-jvm org.jetbrains.kotlin/kotlin-stdlib com.fasterxml.jackson.core/jackson-annotations org.jetbrains.kotlin/kotlin-stdlib-jdk8 org.jetbrains.kotlin/kotlin-stdlib-jdk7 com.fasterxml.jackson.core/jackson-databind com.squareup.okio/okio com.fasterxml.jackson.core/jackson-core]]
                                                              [dev.langchain4j/langchain4j-open-ai "1.0.1" :exclusions [com.fasterxml.jackson.core/jackson-annotations com.fasterxml.jackson.core/jackson-databind com.fasterxml.jackson.core/jackson-core]]
                                                              [dev.langchain4j/langchain4j-ollama "1.0.1-beta6" :exclusions [com.fasterxml.jackson.core/jackson-annotations com.fasterxml.jackson.core/jackson-databind com.fasterxml.jackson.core/jackson-core]]
                                                              [dev.langchain4j/langchain4j "1.0.1" :exclusions [com.fasterxml.jackson.core/jackson-annotations com.fasterxml.jackson.core/jackson-databind com.fasterxml.jackson.core/jackson-core]]
                                                              [dev.langchain4j/langchain4j-bedrock "1.0.1-beta6" :exclusions [com.fasterxml.jackson.core/jackson-annotations com.fasterxml.jackson.core/jackson-databind com.fasterxml.jackson.core/jackson-core]]
                                                              [io.factorhouse/slipway-jetty10 "1.1.20"]
                                                              [org.apache.santuario/xmlsec "2.3.4"] ;; Explicit due to CVE vuln in transitive dep via com.coveo/saml-client, we choose the latest of the 2.3.x branch contained in coveo 4.1.x
                                                              [org.apache.velocity/velocity-engine-core "2.4" :exclusions [org.apache.commons/commons-lang3]] ;; Explicit bump to 2.4 to avoid phantom shaded 2.8.0 inclusion triggering CVE, see: https://github.com/aquasecurity/trivy/discussions/7673
                                                              [com.coveo/saml-client "4.1.2" :exclusions [javax.servlet/javax.servlet-api ;; Jetty 10.x brings in its own impl of the servlet-api (different lib, same java path), we prefer that.
                                                                                                          org.apache.httpcomponents/httpcore ;; Clj-http brings in http-core 4.4.14 vs 4.4.15 in this dep
                                                                                                          io.dropwizard.metrics/metrics-core ;; Metrics-clj brings in an ancient version of io.dropwizard, if saml stops working look at rm'ing metrics-core as a fix
                                                                                                          org.apache.commons/commons-lang3]]]} ;; Jetty brings in 3.12, confluent avro serdes 3.14.0, in LDAP dep, coveo has both 3.12 and 3.11


             ;; Flex profiles
             :flex-test-base             {}
             :flex-base                  {:source-paths   ["modules/flex/src"]
                                          :init-ns        flex-dev
                                          :resource-paths ["modules/flex/resources"]
                                          :dependencies   [;; Bring in explicitly for Flex, as we exclude this package for com.coveo/saml-client (see notes above).
                                                           [org.apache.commons/commons-lang3 "3.17.0"] ;; Keep this version in line with what io.confluent/*-serializer uses (how Kpow transitively brings in commons-lang3) - correct valid for 7.9.0 libs
                                                           [org.rocksdb/rocksdbjni "7.9.2"]]} ;; Bring in line with Kafka streams. We bring this in for the rocksdb persistence layer.
             :flex-enterprise-base       {:main         factorhouse.flex
                                          :aot          [factorhouse.flex]
                                          :source-paths ["modules/flex/src-license/enterprise"
                                                         "modules/flex/src-product/enterprise"]
                                          :target-path  "target/flex-enterprise"
                                          :test-paths   ["modules/flex/test-license/enterprise"]}
             :flex-community-base        {:source-paths ["modules/flex/src-license/community"
                                                         "modules/flex/src-product/community"]
                                          :test-paths   ["modules/flex/test-license/community"]
                                          :target-path  "target/flex-community"
                                          :main         factorhouse.flex
                                          :aot          [factorhouse.flex]}

             :flex-enterprise-uberjar    {:uberjar-name "flex-java17-standalone.jar"}
             :flex-enterprise            [:java-17-base :flex-enterprise-base :flex-base :flex-enterprise-uberjar]

             :flex-enterprise-8-uberjar  {:uberjar-name "flex-java8-standalone.jar"}
             :flex-enterprise-8          [:java-8-base :flex-enterprise-base :flex-base :flex-enterprise-8-uberjar]

             :flex-enterprise-11-uberjar {:uberjar-name "flex-java11-standalone.jar"}
             :flex-enterprise-11         [:java-11-base :flex-enterprise-base :flex-base :flex-enterprise-11-uberjar]


             :flex-community-uberjar     {:uberjar-name "flex-ce-standalone.jar"}
             :flex-community             [:java-17-base :flex-community-base :flex-base :flex-community-uberjar]

             ;; Flow profiles
             :flow-base                  {:source-paths ["modules/flow/src"]
                                          :init-ns      flow-dev}
             :flow-test-base             {}
             :flow-enterprise-base       {:source-paths ["modules/flow/src-license/enterprise"
                                                         "modules/flow/src-product/enterprise"]
                                          :test-paths   ["modules/flow/test-license/enterprise"
                                                         "modules/flow/test"]
                                          :target-path  "target/flow"
                                          :main         factorhouse.flow
                                          :aot          [factorhouse.flow]}

             :flow-enterprise-uberjar    {:uberjar-name "flow-java17-standalone.jar"}
             :flow-enterprise            [:java-17-base :flow-enterprise-base :flow-base :kpow-base :kpow-java-11-base :flex-base :flow-enterprise-uberjar]

             ;; Kpow profiles
             :kpow-test-base             {:java-source-paths ["modules/kpow/src-java-dev"]}
             :kpow-java-8-base           {:source-paths ["modules/kpow/src-8"]
                                          :dependencies [[clj-antlr "0.2.13"]]} ;; ksql parsing, final version of clj-antlr that support Java8, contains xtive dep of javax.json with CVE-2023-7272
             :kpow-java-11-base          {:source-paths ["modules/kpow/src-11"]
                                          :dependencies [[clj-antlr "0.2.14"]]} ;; ksql parsing, latest version of clj-antlr, requires Java11+.
             :kpow-base                  {:init-ns           kpow-dev
                                          :source-paths      ["modules/kpow/src"]
                                          :resource-paths    ["modules/kpow/resources"]
                                          :java-source-paths ["modules/kpow/src-java"]
                                          :dependencies      [;;; Kakfa libs
                                                              ;; we prefer the confluent specific kafka-clients (they are required for Confluent Cloud Schema Registry OAuth)
                                                              ;; note: keep this version in-line(-ish minor bumps ahead are ok) with the confluent libs below, as we use the kafka-client-ccs version from those libs
                                                              [org.apache.kafka/kafka-streams "3.9.0" :exclusions [org.apache.kafka/kafka-clients]]
                                                              [io.factorhouse/kpow-streams-agent "1.0.0"]

                                                              ;;; Confluent Serdes
                                                              [org.apache.commons/commons-compress "1.26.2" :exclusions [org.apache.commons/commons-lang3]] ;; 7.9.0 serializer includes conflicts, we favor the avro transitive dependency version, lang3 excluded because cflt proto serializer brings in 3.17.0 vs 3.14.0 here
                                                              [io.confluent/kafka-avro-serializer "7.9.0" :exclusions [com.google.re2j/re2j]] ;; glue 1.1.23 brings in a later version of everit-schema with a later version of resj as a xtive dep, looks fine from the changelog

                                                              ;; Both confluent 7.9.0 and glue-serdes 1.1.22 use protobuf-java-* 3.25.5
                                                              [io.confluent/kafka-protobuf-serializer "7.9.0" :exclusions [com.squareup.okio/okio-jvm]] ;; internal conflicts between 3.4.0 and 3.9.0 (!), so we exclude and let glue bring in 3.4.0 (below)

                                                              [commons-validator "1.9.0" :exclusions [commons-beanutils]] ;; internal conflicts in json-schema so we chose latest here
                                                              [io.confluent/kafka-json-schema-serializer "7.9.0" :exclusions [org.jetbrains.kotlin/kotlin-stdlib]] ;; conflicts with protobuf schema (2.0.20 here vs 1.9.10 in protobuf) we prefer protobuf schema

                                                              ;; ksqldb-api-client is confluent community licensed, which is different from the above serializer libraries.
                                                              ;; We have checked and we believe this is fine, have also asked on the ksqldb-user google group without answer.
                                                              ;; Note: starting in 7.6.0 this lib starts bringing in -ce deps (confluent enterprise) rather than -css (confluent community) we avoid them below
                                                              [io.confluent.ksql/ksqldb-api-client "7.9.0" :exclusions [io.confluent/broker-plugins ;; 7.6.0 introduces broker-plugins which leads to kafka-clients-ce
                                                                                                                        org.apache.kafka/kafka-streams]] ;; 7.7.1 brings in kafka-streams-ce

                                                              ;; AWS libs
                                                              [software.amazon.awssdk/kafkaconnect "2.31.6"]

                                                              ;; Core AWS libs in msk-iam-auth and msk-iam-auth
                                                              [software.amazon.awssdk/sso "2.31.6"]
                                                              [software.amazon.awssdk/ssooidc "2.31.6"]
                                                              [software.amazon.msk/aws-msk-iam-auth "2.3.2" :exclusions [com.fasterxml.jackson.core/jackson-databind]]

                                                              ;; Auth library to enable GCP MSK + Kpow integration
                                                              ;; Notes:
                                                              ;;   * 1.35.2 resolves CVE-2021-22573
                                                              ;;   * This version is used by a more recent build of `managed-kafka-auth-login-handler` yet to be deployed to maven
                                                              ;;   * https://github.com/googleapis/managedkafka/commit/b0fd07a6034eada2d48270c200eb5ffe016cef9f
                                                              ;;   * https://github.com/googleapis/managedkafka/pull/39
                                                              [com.google.api-client/google-api-client "1.35.2"]
                                                              [com.google.cloud.hosted.kafka/managed-kafka-auth-login-handler "1.0.6" :exclusions [org.apache.kafka/kafka-clients
                                                                                                                                                   com.google.http-client/google-http-client
                                                                                                                                                   com.google.http-client/google-http-client-gson]]

                                                              ;; Core AWS libs in schema-registry-serde and schema-registry-serde
                                                              [software.amazon.awssdk/glue "2.31.6"]
                                                              [software.amazon.awssdk/arns "2.31.6"]
                                                              [software.amazon.awssdk/url-connection-client "2.31.6"]
                                                              [org.jetbrains.kotlin/kotlin-stdlib-jdk8 "1.9.10"] ;; internal conflicts in srs 1.1.23 between 1.7.10 and and 1.8.0, both of which have xtive conflicts with confluent lib at 1.9.10
                                                              [software.amazon.glue/schema-registry-serde "1.1.23" :exclusions [org.apache.kafka/kafka-clients ;; conflunt 7.9.0 brings 3.9.0 and glue brings in 3.6.1, we prefer confluent
                                                                                                                                org.jetbrains.kotlin/kotlin-reflect ;; confluent 7.9.0 brings in 2.0.0, glue brings in 1.7.10, we prefer confluent
                                                                                                                                org.jetbrains.kotlin/kotlin-scripting-compiler-embeddable ;; confluent 7.9.0 brings in 1.9.10, glue brings in 1.7.10, we prefer confluent
                                                                                                                                org.jetbrains.kotlin/kotlin-scripting-compiler-impl-embeddable ;; confluent 7.9.0 brings in 1.9.10, glue brings in 1.7.10, we prefer confluent
                                                                                                                                com.google.api.grpc/proto-google-common-protos ;; confluent 7.9.0 brings in 2.22.1, glue brings in 2.7.4, we prefer confluent
                                                                                                                                io.github.classgraph/classgraph]] ;; confluent 7.9.0 brings in 4.8.138, glue brings in 4.8.120, we prefer confluent

                                                              ;; Minor libs last in precedence
                                                              [tech.allegro.schema.json2avro/converter "0.2.11"]]} ;; generate AVRO from JSON+Schema

             :kpow-enterprise-base       {:main         factorhouse.kpow
                                          :aot          [factorhouse.kpow]
                                          :source-paths ["modules/kpow/src-license/enterprise"
                                                         "modules/kpow/src-product/enterprise"]
                                          :target-path  "target/kpow-enterprise"
                                          :test-paths   ["modules/kpow/test-license/enterprise"]}
             :kpow-community-base        {:source-paths ["modules/kpow/src-license/community"
                                                         "modules/kpow/src-product/community"]
                                          :test-paths   ["modules/kpow/test-license/community"]
                                          :target-path  "target/kpow-community"
                                          :main         factorhouse.kpow
                                          :aot          [factorhouse.kpow]}


             :kpow-enterprise-8-uberjar  {:uberjar-name "kpow-java8-standalone.jar"}
             :kpow-enterprise-8          [:java-8-base :kpow-enterprise-base :kpow-base :kpow-enterprise-8-uberjar :kpow-java-8-base]

             :kpow-enterprise-11-uberjar {:uberjar-name "kpow-java11-standalone.jar"}
             :kpow-enterprise-11         [:java-11-base :kpow-enterprise-base :kpow-base :kpow-enterprise-11-uberjar :kpow-java-11-base]

             :kpow-enterprise-uberjar    {:uberjar-name "kpow-java17-standalone.jar"}
             :kpow-enterprise            [:java-17-base :kpow-enterprise-base :kpow-base :kpow-enterprise-uberjar :kpow-java-11-base]

             :kpow-community-8-uberjar   {:uberjar-name "kpow-ce-java8-standalone.jar"}
             :kpow-community-8           [:java-8-base :kpow-community-base :kpow-base :kpow-community-8-uberjar :kpow-java-8-base]

             :kpow-community-uberjar     {:uberjar-name "kpow-ce-standalone.jar"}
             :kpow-community             [:java-17-base :kpow-community-base :kpow-base :kpow-community-uberjar :kpow-java-11-base]

             :kpow-aws-mkt-base          {:main         factorhouse.kpow
                                          :aot          [factorhouse.kpow]
                                          :dependencies [[software.amazon.awssdk/marketplacemetering "2.31.6"]]}
             :kpow-aws-mkt-lm-base       {:main         factorhouse.kpow
                                          :aot          [factorhouse.kpow]
                                          :dependencies [[software.amazon.awssdk/licensemanager "2.31.6"]]}
             :kpow-aws-mkt-pro-src       {:source-paths   ["modules/kpow/src-license/aws-mkt-pro"
                                                           "modules/kpow/src-product/enterprise"]
                                          :test-paths     ["modules/kpow/test-license/aws-mkt-pro"]
                                          :resource-paths ["resources/kpow-aws-mkt-pro"]
                                          :uberjar-name   "kpow-aws-mkt-pro-standalone.jar"}
             :kpow-aws-mkt-lm-src        {:source-paths      ["modules/kpow/src-license/aws-mkt-lm"
                                                              "modules/kpow/src-product/aws-mkt-lm"
                                                              "modules/kpow/src-product/enterprise"]
                                          :test-paths        ["modules/kpow/test-license/aws-mkt-lm"]
                                          :java-source-paths ["modules/kpow/src-license/aws-mkt-lm-java"]
                                          :resource-paths    ["resources/kpow-aws-mkt-lm"]
                                          :uberjar-name      "kpow-aws-mkt-lm-standalone.jar"}
             :kpow-aws-mkt-pro           [:java-17-base :kpow-aws-mkt-base :kpow-base :kpow-aws-mkt-pro-src :kpow-java-11-base]
             :kpow-aws-mkt-lm            [:java-17-base :kpow-aws-mkt-lm-base :kpow-base :kpow-aws-mkt-lm-src :kpow-java-11-base]

             ;; Uberjar profile (used by all builds)
             :uberjar                    {:prep-tasks  ["clean" "javac" "compile"]
                                          :omit-source true
                                          :aot         :all}

             ;; Dev + Test profiles
             :nuke                       {:clean-targets ^{:protect false :replace true} ["resources/public/js" "dev-resources/public/js" :target-path ".shadow-cljs"]}
             :smoke                      {:pedantic? :abort}
             :kaocha                     {:dependencies [[lambdaisland/kaocha "1.91.1392" :exclusions [org.clojure/tools.cli org.clojure/spec.alpha]]]}
             :cljs                       {:dependencies     [[thheller/shadow-cljs "2.28.22" :exclusions [com.google.code.gson/gson nrepl com.google.re2j/re2j com.google.guava/guava]]
                                                             [metosin/reitit-frontend "0.7.2"]
                                                             [com.cognitect/transit-cljs "0.8.280"]]
                                          :nrepl-middleware [shadow.cljs.devtools.server.nrepl/middleware]
                                          ;; Set a bigger stack size because of highlight.js and these closure issues:
                                          ;; https://github.com/thheller/shadow-cljs/issues/1015
                                          ;; https://github.com/google/closure-compiler/issues/3945
                                          :jvm-opts         ["-Xss16m"]}
             :dev                        {:source-paths   ["src-dev"]
                                          :resource-paths ["dev-resources"]
                                          :plugins        [[dev.weavejester/lein-cljfmt "0.13.0"]
                                                           [com.github.liquidz/antq "2.11.1276" :exclusions [org.codehaus.plexus/plexus-utils]]
                                                           [lein-shell "0.5.0"]]
                                          :dependencies   [[borkdude/edamame "1.4.27"]
                                                           [org.jsoup/jsoup "1.18.3"]
                                                           [org.clojure/data.csv "1.1.0"]
                                                           [clj-test-containers "0.7.4" :exclusions [org.jetbrains/annotations org.apache.commons/commons-compress net.java.dev.jna/jna]]
                                                           [enlive "1.1.6"]
                                                           [camel-snake-kebab "0.4.3"]
                                                           [clj-kondo "2025.02.20"]]}
             :unit-base                  {:aot [kpow.kafka.serdes]}
             :unit                       [:java-17-base :enterprise-base :kpow-base :flex-base :unit-base]
             :local-kpow                 [:java-17-base :cljs
                                          {:java-source-paths ["modules/kpow/src-java-dev"]
                                           :aot               [kpow.kafka.serdes]}]
             :local-flex                 [:java-17-base :cljs]
             :local-flow                 [:local-kpow :local-flex]
             :simple-consumers           {:test-paths   ["modules/kpow/test-flink"]
                                          :jvm-opts     ["--add-opens=java.base/java.util=ALL-UNNAMED"
                                                         "--add-opens=java.base/java.lang=ALL-UNNAMED"
                                                         "--add-opens=java.base/java.util.concurrent.atomic=ALL-UNNAMED"]
                                          :dependencies [[org.apache.flink/flink-core "1.13.2"]
                                                         [org.apache.flink/flink-clients_2.12 "1.13.2" :exclusions [org.slf4j/slf4j-api]]
                                                         [org.apache.flink/flink-connector-kafka_2.12 "1.13.2" :exclusions [org.slf4j/slf4j-api]]]}
             :test-simple-consumers      [:dev :simple-consumers]
             :test-streams               {:resource-paths ["dev-resources"]
                                          :source-paths   ["test-streams"]
                                          :prep-tasks     ^:replace ["clean" "javac" "compile"]
                                          :main           factorhouse.test-streams
                                          :aot            :all
                                          :omit-source    true}}

  :aliases {"redoc"                            ["shell" "open" "scripts/redoc.html"]
            "test-kpow"                        ["with-profile" "+kaocha,+smoke,+kpow-test-base" "run" "-m" "kaocha.runner"]
            "test-kpow-api"                    ["with-profile" "+kaocha,+smoke,+kpow-test-base,+kpow-enterprise" "run" "-m" "kaocha.runner" "kpow-api"]
            "test-flex"                        ["with-profile" "+kaocha,+smoke,+flex-test-base" "run" "-m" "kaocha.runner"]
            "test-flow"                        ["with-profile" "+kaocha,+smoke,+flow-test-base" "run" "-m" "kaocha.runner"]
            "unit"                             ["with-profile" "+kaocha,+smoke,+kpow-test-base,+kpow-enterprise" "run" "-m" "kaocha.runner", "unit"]
            "check"                            ["with-profile" "+smoke" "check"]
            "fmt"                              ["with-profile" "+smoke" "cljfmt" "check"]
            "fmtfix"                           ["with-profile" "+smoke" "cljfmt" "fix"]
            "gen-kpow-enterprise-openapi-spec" ["with-profile" "+kpow-enterprise" "run" "-m" "openapi/kpow-enterprise-openapi-spec"]
            "release-kpow"                     ["do"
                                                ["nuke"]
                                                ["shell" "npm" "run" "css-compile"]
                                                ["release-kpow-cljs"]
                                                ["uberjar"]]
            "release-kpow-fargate"             ["do"
                                                ["nuke"]
                                                ["shell" "npm" "run" "css-compile"]
                                                ["release-kpow-profiler-cljs"]
                                                ["uberjar"]]
            "release-flex"                     ["do"
                                                ["nuke"]
                                                ["shell" "npm" "run" "css-compile"]
                                                ["release-flex-cljs"]
                                                ["uberjar"]]
            "release-flow"                     ["do"
                                                ["nuke"]
                                                ["shell" "npm" "run" "css-compile"]
                                                ["release-flow-cljs"]
                                                ["uberjar"]]
            "nuke"                             ["with-profile" "nuke" "clean"]
            "release-kpow-cljs"                ["with-profile" "+cljs" "run" "-m" "shadow.cljs.devtools.cli" "release" "kpow"]
            "release-kpow-profiler-cljs"       ["with-profile" "+cljs" "run" "-m" "shadow.cljs.devtools.cli" "release" "kpow-profiler"]
            "release-flex-cljs"                ["with-profile" "+cljs" "run" "-m" "shadow.cljs.devtools.cli" "release" "flex"]
            "release-flow-cljs"                ["with-profile" "+cljs" "run" "-m" "shadow.cljs.devtools.cli" "release" "flow"]
            "cljs-watch"                       ["with-profile" "+cljs,+local,+kpow-enterprise" "run" "-m" "shadow.cljs.devtools.cli" "watch" "kpow"]
            "cljs-watch-flow-enterprise"       ["with-profile" "+cljs,+local,+flow-enterprise" "run" "-m" "shadow.cljs.devtools.cli" "watch" "flow"]
            "cljs-watch-kpow-community"        ["with-profile" "+cljs,+local,+kpow-community" "run" "-m" "shadow.cljs.devtools.cli" "watch" "kpow"]
            "cljs-check-kpow-enterprise"       ["with-profile" "+cljs,+local,+kpow-enterprise" "run" "-m" "shadow.cljs.devtools.cli" "check" "kpow"]
            "cljs-watch-kpow-enterprise"       ["with-profile" "+cljs,+local,+kpow-enterprise" "run" "-m" "shadow.cljs.devtools.cli" "watch" "kpow"]
            "cljs-watch-flex-community"        ["with-profile" "+cljs,+local,+flex-community" "run" "-m" "shadow.cljs.devtools.cli" "watch" "flex"]
            "cljs-watch-flex-enterprise"       ["with-profile" "+cljs,+local,+flex-enterprise" "run" "-m" "shadow.cljs.devtools.cli" "watch" "flex"]
            "cljs-watch-kpow-aws-se-1"         ["with-profile" "+cljs,+local,+kpow-aws-mkt-pro" "run" "-m" "shadow.cljs.devtools.cli" "watch" "kpow"]
            "cljs-watch-kpow-aws-se-lm"        ["with-profile" "+cljs,+local,+kpow-aws-mkt-lm" "run" "-m" "shadow.cljs.devtools.cli" "watch" "kpow"]}

  :repositories [["confluent" "https://packages.confluent.io/maven/"]]

  :java-source-paths ["modules/factorhouse/src-java"]
  :source-paths ["modules/factorhouse/src"]
  :test-paths ["test"]

  :pedantic? :warn)
